# Virtual Media Management
use strict;
use warnings;
our (%gui, %chooser, %EMedVar);

sub show_dialog_vmm() {
    &addrow_log('Retrieving global media information...');
    &busy_window($gui{windowMain}, 0, 'watch');
    &fill_list_vmmhd();
    &fill_list_vmmdvd();
    &fill_list_vmmfloppy();
    &addrow_log('Retrieved global media information.');
    &busy_window($gui{windowMain}, 0);
    $gui{dialogVMM}->run;
    $gui{dialogVMM}->hide;
}

# Recurses through the media for populating the VMM media lists, including
# identifying snapshots
sub recurse_media_snapshot() {
    my ($treestore, $IMedium, $iter, $type) = @_;
    my %mattr = (name       => 1,
                 size       => 1,
                 logsize    => 1,
                 refresh    => 1,
                 accesserr  => 1,
                 machineids => 1,
                 children   => 1,
                 location   => 1,
                 type       => 1); # medium attributes to get

    &get_imedium_attrs(\%mattr, $IMedium);

    my $citer = $treestore->append($iter);
    my $gnames;

    foreach my $id (@{$mattr{machineids}}) {

        my $snames;
        my $IMachine = IVirtualBox_findMachine($gui{websn}, $id);
        my $mname = IMachine_getName($IMachine);
        my @suuids = IMedium_getSnapshotIds($IMedium, $id);

        foreach my $snapid (@suuids) {
            next if ($snapid eq $id);
            my $ISnapshot = IMachine_findSnapshot($IMachine, $snapid);
            my $snapname = ISnapshot_getName($ISnapshot);
            $snames .= "$snapname, ";
        }

        if ($snames) {
            $snames =~ s/, $//;
            $gnames .= "$mname ($snames), ";}
        else { $gnames .= "$mname, "; }
    }

    $gnames = '<None>' if (!$gnames);
    $gnames =~ s/, $//; # Remove any trailing,

    if ($type eq 'HardDisk') {
        if ($mattr{refresh} eq 'Inaccessible') {
            $treestore->set($citer, 0, $mattr{name},
                                    1, $IMedium,
                                    2, $gnames,
                                    3, 0,
                                    4, 0,
                                    5, $gui{img}{Error},
                                    6, $mattr{accesserr},
                                    7, $mattr{location},
                                    8, $mattr{type});
        }
        else {
            $treestore->set($citer, 0, $mattr{name},
                                    1, $IMedium,
                                    2, $gnames,
                                    3, &bytesToX($mattr{size}),
                                    4, &bytesToX($mattr{logsize}),
                                    6, $mattr{location}, # Tooltip can be location
                                    7, $mattr{location},
                                    8, $mattr{type});
        }
    }
    elsif ($type eq 'DVD') {
        if ($mattr{refresh} eq 'Inaccessible') {
            $treestore->set($citer, 0, $mattr{name},
                                    1, $IMedium,
                                    2, $gnames,
                                    3, 0,
                                    4, $gui{img}{Error},
                                    5, $mattr{accesserr},
                                    6, $mattr{location},
                                    7, $mattr{type});
        }
        else {
            $treestore->set($citer, 0, $mattr{name},
                                    1, $IMedium,
                                    2, $gnames,
                                    3, &bytesToX($mattr{size}),
                                    5, $mattr{location}, # Tooltip can be location
                                    6, $mattr{location},
                                    7, $mattr{type});
        }
    }
    else { # Defaults to floppy
        if ($mattr{refresh} eq 'Inaccessible') {
            $treestore->set($citer, 0, $mattr{name},
                                    1, $IMedium,
                                    2, $gnames,
                                    3, 0,
                                    4, $gui{img}{Error},
                                    5, $mattr{accesserr}, # Tooltip can be access error
                                    6, $mattr{location},
                                    7, $mattr{type});
        }
        else {
            $treestore->set($citer, 0, $mattr{name},
                                    1, $IMedium,
                                    2, $gnames,
                                    3, &bytesToX($mattr{size}),
                                    5, $mattr{location}, # Tooltip can be location
                                    6, $mattr{location},
                                    7, $mattr{type});
        }
    }

    &recurse_media_snapshot($treestore, $_, $citer, $type) foreach (@{$mattr{children}});
}

# Handles GUI changes when user selects a different tab
sub vmm_tabchanged() {
    my ($widget, $focus, $page) = @_;
    $gui{labelVMMAttachedToField}->set_text('');
    $gui{labelVMMLocationField}->set_text('');
    $gui{labelVMMTypeField}->set_text('');
    $gui{toolbuttonVMMRemove}->set_sensitive(0);
    $gui{toolbuttonVMMRelease}->set_sensitive(0);
    $gui{toolbuttonVMMCopy}->set_sensitive(0);
    $gui{toolbuttonVMMModify}->set_sensitive(0);

    #We need to re-evaluate selection on tab change
    if ($page == 0) {
        $gui{toolbuttonVMMAdd}->set_label('Add Hard Disk');
        &onsel_list_vmmhd() if ($gui{treeviewVMMHD}->get_selection->get_selected());
    }
    elsif ($page == 1) {
        $gui{toolbuttonVMMAdd}->set_label('Add CD/DVD');
        &onsel_list_vmmdvd() if ($gui{treeviewVMMDVD}->get_selection->get_selected());
    }
    else {
        $gui{toolbuttonVMMAdd}->set_label('Add Floppy');
        &onsel_list_vmmfloppy() if ($gui{treeviewVMMFloppy}->get_selection->get_selected());
    }
}

# Releases a medium from a guest
sub vmm_release() {
    my $mediumref;
    my $page = $gui{notebookVMM}->get_current_page();
    my $warn = 0;

    if ($page == 0) { $mediumref = &getsel_list_vmmhd(); }
    elsif ($page == 1) { $mediumref = &getsel_list_vmmdvd(); }
    else { $mediumref = &getsel_list_vmmfloppy(); }

    my @guuids = IMedium_getMachineIds($$mediumref{IMedium}); # Dont use &get_imedium_attrs as only IMedium_get call in this sub

    foreach my $id (@guuids) {
        my $IMachine = IVirtualBox_findMachine($gui{websn}, $id);
        my @IMediumAttachment = IMachine_getMediumAttachments($IMachine);

        foreach my $attach (@IMediumAttachment) {
            if ($$attach{medium} eq $$mediumref{IMedium}) {
                my $sref = &get_session($IMachine);

                if ($$sref{Type} eq 'WriteLock') { # Cannot do it if it's a shared lock
                    IMachine_detachDevice($$sref{IMachine}, $$attach{controller}, $$attach{port}, $$attach{device});
                    IMachine_saveSettings($$sref{IMachine});
                }
                else { $warn = 1; }

                ISession_unlockMachine($$sref{ISession}) if (ISession_getState($$sref{ISession}) eq 'Locked');
            }
        }
    }

    if ($warn == 1) { &show_err_msg('mediuminuse', $gui{messagedialogWarning}, " ($$mediumref{Name})"); }
    else { &addrow_log("Medium $$mediumref{Name} released."); }

    if ($page == 0) { &fill_list_vmmhd(); }
    elsif ($page == 1) { &fill_list_vmmdvd(); }
    else { &fill_list_vmmfloppy(); }
}

sub vmm_rem() {
    my $page = $gui{notebookVMM}->get_current_page();

    if ($page == 0) {
        my $hdref = &getsel_list_vmmhd();
        my $response = $gui{dialogRemoveDelete}->run;
        $gui{dialogRemoveDelete}->hide;

        if ($response eq '1') { # Deletes Disk
            # Use get state and not refresh state to ensure we have latest info
            my $MediumState = IMedium_refreshState($$hdref{IMedium});
            if ($MediumState eq 'Created' or $MediumState eq 'Inaccessible') {
                my $IProgress = IMedium_deleteStorage($$hdref{IMedium});
                &show_progress_window($IProgress, "Deleting hard disk $$hdref{Name}...", 'cancel', $gui{dialogVMM});
                &addrow_log("Deleted hard disk $$hdref{Name}.");
                &fill_list_vmmhd();
            }
            else { &show_err_msg('deletemedium', $gui{messagedialogWarning}, " ( $$hdref{Name})"); }
        }
        elsif ($response eq '2') { # Removes Disk
            IMedium_close($$hdref{IMedium});
            &addrow_log("Storage $$hdref{Name} removed.");
            &fill_list_vmmhd();
        }
    }
    elsif ($page == 1) {
        my $dvdref = &getsel_list_vmmdvd();
        IMedium_close($$dvdref{IMedium});
        &addrow_log("Storage $$dvdref{Name} removed.");
        &fill_list_vmmdvd();
    }
    else {
        my $floppyref = &getsel_list_vmmfloppy();
        IMedium_close($$floppyref{IMedium});
        &addrow_log("Storage $$floppyref{Name} removed.");
        &fill_list_vmmfloppy();
    }
}

# Adds a harddisk/dvd/floppy image to the VMM
sub vmm_add() {
    my ($location, $filearrayref) = @_;
    my $page = $gui{notebookVMM}->get_current_page();
    return if (!$location);

    if ($page == 0) {
            foreach my $hd (@{$filearrayref}) {
                next if (!$hd->{FileName});
                next if ($hd->{FileName} eq '..' or $hd->{Type} eq '(Dir)');
                IVirtualBox_openMedium($gui{websn}, "$location/$hd->{FileName}", 'HardDisk', 'ReadWrite', 0);
                &addrow_log("Adding Hard Disk $hd->{FileName} to VMM");
            }

            &fill_list_vmmhd();
        }
        elsif ($page == 1) {
            foreach my $dvd (@{$filearrayref}) {
                next if (!$dvd->{FileName});
                next if ($dvd->{FileName} eq '..' or $dvd->{Type} eq '(Dir)');
                IVirtualBox_openMedium($gui{websn}, "$location/$dvd->{FileName}", 'DVD', 'ReadOnly', 0);
                &addrow_log("Adding DVD/CD $dvd->{FileName} to VMM");
            }

            &fill_list_vmmdvd();
        }
        else {
            foreach my $floppy (@{$filearrayref}) {
                next if (!$floppy->{FileName});
                next if ($floppy->{FileName} eq '..' or $floppy->{Type} eq '(Dir)');
                IVirtualBox_openMedium($gui{websn}, "$location/$floppy->{FileName}", 'Floppy', 'ReadWrite', 0);
                &addrow_log("Adding Floppy $floppy->{FileName} to VMM");
            }

            &fill_list_vmmfloppy();
        }
}


# Refreshes the media on the currently selected page
sub vmm_refresh() {
    my $page = $gui{notebookVMM}->get_current_page();

    if ($page == 0) { &fill_list_vmmhd(); }
    elsif ($page == 1) { &fill_list_vmmdvd(); }
    else { &fill_list_vmmfloppy(); }

}

# Displays the modify medium window
sub show_vmm_modify() {
    my $hdref = &getsel_list_vmmhd();
    $gui{labelVMMModifySubTitle}->set_text('Modifying: ' . $$hdref{Name});
    &combobox_set_active_text($gui{comboboxVMMModifyType}, $$hdref{Type});

    my $response = $gui{dialogVMMModify}->run;
    $gui{dialogVMMModify}->hide;

    if ($response eq 'ok') {
        my $newtype = &getsel_combo($gui{comboboxVMMModifyType}, 0);
        IMedium_setType($$hdref{IMedium}, $newtype) if ($$hdref{Type} ne $newtype);
        &fill_list_vmmhd();
        &addrow_log("Request sent to modify $$hdref{Name} to type $newtype");
    }
}

# Displays the copy HD medium window
sub show_vmm_copy() {
    my $hdref = &getsel_list_vmmhd();
    my $newdiskname = $$hdref{Name};
    $newdiskname =~ s/\.vdi$//i;
    $newdiskname =~ s/\.vmdk$//i;
    $newdiskname =~ s/\.vhd$//i;
    $newdiskname =~ s/\.hdd$//i;
    $newdiskname =~ s/\.parallels$//i;

    $gui{entryCopyHDName}->set_text($newdiskname . '_copy' . int(rand(9999)));
    $gui{comboboxCopyHDFormat}->set_active(0);
    $gui{radiobuttonCopyHDDynamic}->show();
    $gui{radiobuttonCopyHDFixed}->show();
    $gui{radiobuttonCopyHDSplit}->hide();

    my $response = $gui{dialogCopyHD}->run;
    $gui{dialogCopyHD}->hide();
    my $diskname = $gui{entryCopyHDName}->get_text();
    $diskname =~ s/\.vdi$//i;
    $diskname =~ s/\.vmdk$//i;
    $diskname =~ s/\.vhd$//i;
    $diskname =~ s/\.hdd$//i;
    $diskname =~ s/\.parallels$//i;

    if ($diskname and ($response eq 'ok')) {
        my $variant = $EMedVar{Standard}; # Standard is Dynamic

        if ($gui{radiobuttonCopyHDFixed}->get_active()) { $variant = $EMedVar{Fixed}; }
        elsif ($gui{radiobuttonCopyHDSplit}->get_active()) { $variant = $EMedVar{VmdkSplit2G}; }

        $gui{dialogRemoteFileChooser}->set_transient_for($gui{dialogVMM});
        $gui{dialogRemoteFileChooser}->set_title("Save location for $diskname on $endpoint");
        my (undef, $basedir, undef) = fileparse($$hdref{Location});
        $chooser{filter} = ' ^'; # Effectively won't match any files, listing directories only
        $chooser{handler} = \&handle_copyhdfilechooser;
        $chooser{selector} = 'GTK_SELECTION_SINGLE';
        $chooser{userdata} = [$diskname, $$hdref{IMedium}, &getsel_combo($gui{comboboxCopyHDFormat}, 1), $variant];
        &show_remotefilechooser_window($basedir);
    }

}

# Handles the copying and converting of hard disks after the location is chosen
sub handle_copyhdfilechooser() {
    my ($location, $filearrayref, $userdata) = @_;
    my $file = ${$filearrayref}[0]->{FileName};
    my $type = ${$filearrayref}[0]->{Type};

    # Depending on what the user does, there will either be an additional directory
    # to append or not. Type (Dir) already excludes (Parent)
    $location .= "/$file" if ($file and $type eq '(Dir)');

    my $ext = 'hdd';
    $ext = $$userdata[2] unless ($$userdata[2] eq 'parallels');

    my $IMedium = IVirtualBox_createHardDisk($gui{websn}, $$userdata[2], "$location/$$userdata[0].$ext");

    if ($IMedium) {
        my $IProgress = IMedium_cloneTo($$userdata[1], $IMedium, int($$userdata[3]), undef);
        &show_progress_window($IProgress, "Copying Hard Disk...", '', $gui{dialogVMM});
        &fill_list_vmmhd();
        &addrow_log("Created new hard disk $$userdata[0].$ext from a copy")
    }
    else { &show_err_msg('copydisk', $gui{messagedialogError}); }
}

# Handle the radio button sensitivity when selecting an image format for copying
sub sens_copyhdformat() {
    my $format = &getsel_combo($gui{comboboxCopyHDFormat}, 1);
    $gui{radiobuttonCopyHDDynamic}->set_active(1);

    if ($format eq 'vmdk') {
        $gui{radiobuttonCopyHDDynamic}->show();
        $gui{radiobuttonCopyHDFixed}->show();
        $gui{radiobuttonCopyHDSplit}->show();
    }
    elsif ($format eq 'vdi' or $format eq 'vhd') {
        $gui{radiobuttonCopyHDDynamic}->show();
        $gui{radiobuttonCopyHDFixed}->show();
        $gui{radiobuttonCopyHDSplit}->hide();
    }
    else {
        $gui{radiobuttonCopyHDDynamic}->show();
        $gui{radiobuttonCopyHDFixed}->hide();
        $gui{radiobuttonCopyHDSplit}->hide();
    }
}

1;