# Serializers for missing datatypes in vboxService.pm
use strict;
use warnings;

sub SOAP::Serializer::as_AccessMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AccessMode', %$attr}, $value];
}

sub SOAP::Serializer::as_AdditionsFacilityType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AdditionsFacilityType', %$attr}, $value];
}

sub SOAP::Serializer::as_AdditionsRunLevelType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AdditionsRunLevelType', %$attr}, $value];
}

sub SOAP::Serializer::as_AudioControllerType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AudioControllerType', %$attr}, $value];
}

sub SOAP::Serializer::as_AudioDriverType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AudioDriverType', %$attr}, $value];
}

sub SOAP::Serializer::as_AuthType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AuthType', %$attr}, $value];
}

sub SOAP::Serializer::as_BIOSBootMenuMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:BIOSBootMenuMode', %$attr}, $value];
}

sub SOAP::Serializer::as_BandwidthGroupType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:BandwidthGroupType', %$attr}, $value];
}

sub SOAP::Serializer::as_CPUPropertyType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:CPUPropertyType', %$attr}, $value];
}

sub SOAP::Serializer::as_ChipsetType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:ChipsetType', %$attr}, $value];
}

sub SOAP::Serializer::as_CleanupMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:CleanupMode', %$attr}, $value];
}

sub SOAP::Serializer::as_ClipboardMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:ClipboardMode', %$attr}, $value];
}

sub SOAP::Serializer::as_CloneMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:CloneMode', %$attr}, $value];
}

sub SOAP::Serializer::as_CloneOptions {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:CloneOptions', %$attr}, $value];
}

sub SOAP::Serializer::as_DeviceType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:DeviceType', %$attr}, $value];
}

sub SOAP::Serializer::as_FaultToleranceState {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:FaultToleranceState', %$attr}, $value];
}

sub SOAP::Serializer::as_FirmwareType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:FirmwareType', %$attr}, $value];
}

sub SOAP::Serializer::as_HWVirtExPropertyType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:HWVirtExPropertyType', %$attr}, $value];
}

sub SOAP::Serializer::as_HostNetworkInterfaceType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:HostNetworkInterfaceType', %$attr}, $value];
}

sub SOAP::Serializer::as_ImportOptions {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:ImportOptions', %$attr}, $value];
}

sub SOAP::Serializer::as_KeyboardHidType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:KeyboardHidType', %$attr}, $value];
}

sub SOAP::Serializer::as_LockType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:LockType', %$attr}, $value];
}

sub SOAP::Serializer::as_MediumType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:MediumType', %$attr}, $value];
}

sub SOAP::Serializer::as_NATProtocol {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:NATProtocol', %$attr}, $value];
}

sub SOAP::Serializer::as_NetworkAdapterPromiscModePolicy {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:NetworkAdapterPromiscModePolicy', %$attr}, $value];
}

sub SOAP::Serializer::as_NetworkAdapterType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:NetworkAdapterType', %$attr}, $value];
}

sub SOAP::Serializer::as_NetworkAttachmentType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:NetworkAttachmentType', %$attr}, $value];
}

sub SOAP::Serializer::as_PointingHidType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:PointingHidType', %$attr}, $value];
}

sub SOAP::Serializer::as_PortMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:PortMode', %$attr}, $value];
}

sub SOAP::Serializer::as_ProcessorFeature {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:ProcessorFeature', %$attr}, $value];
}

sub SOAP::Serializer::as_StorageBus {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:StorageBus', %$attr}, $value];
}

sub SOAP::Serializer::as_StorageControllerType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:StorageControllerType', %$attr}, $value];
}

sub SOAP::Serializer::as_USBDeviceFilterAction {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:USBDeviceFilterAction', %$attr}, $value];
}

sub SOAP::Serializer::as_VBoxEventType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:VBoxEventType', %$attr}, $value];
}

sub SOAP::Serializer::as_VirtualSystemDescriptionType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:VirtualSystemDescriptionType', %$attr}, $value];
}

sub SOAP::Serializer::as_VirtualSystemDescriptionValueType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:VirtualSystemDescriptionValueType', %$attr}, $value];
}

1;
