# General GUI related functions and structures
use strict;
use warnings;
use Gtk2 -init;

my $builder = Gtk2::Builder->new;
$builder->add_from_file("$Bin/share/remotebox/remotebox.xml");
$builder->connect_signals();

our %gui = (textbufferEditGenDescription         => $builder->get_object('textbufferEditGenDescription'),
            textbufferSnapshotDescription        => $builder->get_object('textbufferSnapshotDescription'),
            textbufferSnapshotDetailsDescription => $builder->get_object('textbufferSnapshotDetailsDescription'),
            textbufferEditNetGeneric1            => $builder->get_object('textbufferEditNetGeneric1'),
            textbufferEditNetGeneric2            => $builder->get_object('textbufferEditNetGeneric2'),
            textbufferEditNetGeneric3            => $builder->get_object('textbufferEditNetGeneric3'),
            textbufferEditNetGeneric4            => $builder->get_object('textbufferEditNetGeneric4'),
            adjustmentEditSysProcessor           => $builder->get_object('adjustmentEditSysProcessor'),
            adjustmentEditSysProcessorCap        => $builder->get_object('adjustmentEditSysProcessorCap'),
            adjustmentEditStorPortCount          => $builder->get_object('adjustmentEditStorPortCount'),
            appname                              => $builder->get_object('aboutdialog')->get_program_name(),
            appver                               => $builder->get_object('aboutdialog')->get_version(),
            vboxEditIOPorts                      => $builder->get_object('vboxEditIOPorts'),
            websn                                => undef,
            pixbufstatuserror16                  => Gtk2::Gdk::Pixbuf->new_from_file("$Bin/share/remotebox/icons/status_error_16px.png"),
            pixbufotheros                        => Gtk2::Gdk::Pixbuf->new_from_file("$Bin/share/remotebox/icons/os/Other.png"));

our %prefs;

# Fill %gui so we can reference them easily.
foreach ($builder->get_objects) {
    my $id;
    eval{ $id = $_->Gtk2::Buildable::get_name; }; # DONT USE $_->get_name()
    $gui{$id} = $_ if ($id);
}

# We have to register signals manually, which we want to block at some point because we need the sigids
# as blocking any other way is not supported in perl-gtk (other blocking funcs map to null funcs)
our %signal = (fam          => $gui{comboboxNewOSFam}->signal_connect(changed => \&newgen_osfam, $gui{comboboxNewOSVer}),
               ver          => $gui{comboboxNewOSVer}->signal_connect(changed => \&newgen_osver, $gui{comboboxNewOSFam}),
               famedit      => $gui{comboboxEditGenOSFam}->signal_connect(changed => \&gen_osfam, $gui{comboboxEditGenOSVer}),
               veredit      => $gui{comboboxEditGenOSVer}->signal_connect(changed => \&gen_osver, $gui{comboboxEditGenOSFam}),
               audiodrv     => $gui{comboboxEditAudioDriver}->signal_connect(changed => \&audio_driver),
               audioctr     => $gui{comboboxEditAudioCtr}->signal_connect(changed => \&audio_ctr),
               netadaptype1 => $gui{comboboxEditNetType1}->signal_connect(changed => \&net_adapter_type, $gui{checkbuttonEditNetEnable1}),
               netadaptype2 => $gui{comboboxEditNetType2}->signal_connect(changed => \&net_adapter_type, $gui{checkbuttonEditNetEnable2}),
               netadaptype3 => $gui{comboboxEditNetType3}->signal_connect(changed => \&net_adapter_type, $gui{checkbuttonEditNetEnable3}),
               netadaptype4 => $gui{comboboxEditNetType4}->signal_connect(changed => \&net_adapter_type, $gui{checkbuttonEditNetEnable4}),
               netattach1   => $gui{comboboxEditNetAttach1}->signal_connect(changed => \&net_attach, $gui{checkbuttonEditNetEnable1}),
               netattach2   => $gui{comboboxEditNetAttach2}->signal_connect(changed => \&net_attach, $gui{checkbuttonEditNetEnable2}),
               netattach3   => $gui{comboboxEditNetAttach3}->signal_connect(changed => \&net_attach, $gui{checkbuttonEditNetEnable3}),
               netattach4   => $gui{comboboxEditNetAttach4}->signal_connect(changed => \&net_attach, $gui{checkbuttonEditNetEnable4}),
               netname1     => $gui{comboboxEditNetName1}->signal_connect(changed => \&net_name, $gui{checkbuttonEditNetEnable1}),
               netname2     => $gui{comboboxEditNetName2}->signal_connect(changed => \&net_name, $gui{checkbuttonEditNetEnable2}),
               netname3     => $gui{comboboxEditNetName3}->signal_connect(changed => \&net_name, $gui{checkbuttonEditNetEnable3}),
               netname4     => $gui{comboboxEditNetName4}->signal_connect(changed => \&net_name, $gui{checkbuttonEditNetEnable4}),
               genericdrv1  => $gui{comboboxentryEditNetGenDriver1}->signal_connect(changed => \&net_generic_driver, $gui{checkbuttonEditNetEnable1}),
               genericdrv2  => $gui{comboboxentryEditNetGenDriver2}->signal_connect(changed => \&net_generic_driver, $gui{checkbuttonEditNetEnable2}),
               genericdrv3  => $gui{comboboxentryEditNetGenDriver3}->signal_connect(changed => \&net_generic_driver, $gui{checkbuttonEditNetEnable3}),
               genericdrv4  => $gui{comboboxentryEditNetGenDriver4}->signal_connect(changed => \&net_generic_driver, $gui{checkbuttonEditNetEnable4}),
               nameint1     => $gui{comboboxentryEditNetNameInt1}->signal_connect(changed => \&net_name_internal, $gui{checkbuttonEditNetEnable1}),
               nameint2     => $gui{comboboxentryEditNetNameInt2}->signal_connect(changed => \&net_name_internal, $gui{checkbuttonEditNetEnable2}),
               nameint3     => $gui{comboboxentryEditNetNameInt3}->signal_connect(changed => \&net_name_internal, $gui{checkbuttonEditNetEnable3}),
               nameint4     => $gui{comboboxentryEditNetNameInt4}->signal_connect(changed => \&net_name_internal, $gui{checkbuttonEditNetEnable4}),
               stortype     => $gui{comboboxEditStorCtrType}->signal_connect(changed => \&storage_ctrtype));

our (%hostspec, %chooser);

# Work around a stupid bug in Glade 3.10.x that disables toolbutton menus
$gui{toolbuttonStop}->set_menu($gui{menuStop});

# Set the transient window's (ie parent window) sensitivity on
sub transwin_sens_on() {
    my ($window) = @_;
    my $transientwin = $window->get_transient_for();
    $transientwin->set_sensitive(1) if ($transientwin);
}

# Set the transient window's (ie parent window) sensitivity off
sub transwin_sens_off() {
    my ($window) = @_;
    my $transientwin = $window->get_transient_for();
    $transientwin->set_sensitive(0) if ($transientwin);
}

# Ghosts window and optionally sets pointer
sub busy_window() {
    my ($window, $sens, $pointer) = @_;
    $window->set_sensitive($sens);

    if ($pointer) { eval { $window->window->set_cursor(Gtk2::Gdk::Cursor->new($pointer)); }; }
    else { eval{ $window->window->set_cursor(undef); }; }

    Gtk2->main_iteration() while Gtk2->events_pending();
}

# Busy the pointer only
sub busy_pointer() {
    my ($window, $pointer) = @_;
    if ($pointer) { eval { $window->window->set_cursor(Gtk2::Gdk::Cursor->new('watch')); }; }
    else { eval{ $window->window->set_cursor(undef); }; }
    Gtk2->main_iteration() while Gtk2->events_pending();
}


sub handle_bioslogofilechooser() {
    my ($location, $filearrayref) = @_;
    my $file = ${$filearrayref}[0]->{FileName};
    my $type = ${$filearrayref}[0]->{Type};

    # We only care about the first file, there should only be one anyway
    # double check there's a file, it's not .. and it's a bmp
    if ($file and $file ne '..' and $type eq '.bmp') {
        $gui{entryEditSysLogoPath}->set_text("$location/$file");
        &sys_bioslogopath();
    }
}

sub handle_machinefolderchooser() {
    my ($location, $filearrayref) = @_;
    my $file = ${$filearrayref}[0]->{FileName};
    my $type = ${$filearrayref}[0]->{Type};

    # Depending on what the user does, there will either be an additional directory
    # to append or not. Type (Dir) already excludes (Parent)
    $location .= "/$file" if ($file and $type eq '(Dir)');
    $gui{entryVBPrefsGenDefMachineFolder}->set_text($location) if ($location);
}

sub handle_sharedfolderchooser() {
    my ($location, $filearrayref) = @_;
    my $file = ${$filearrayref}[0]->{FileName};
    my $type = ${$filearrayref}[0]->{Type};

    # Depending on what the user does, there will either be an additional directory
    # to append or not. Type (Dir) already excludes (Parent)
    $location .= "/$file" if ($file and $type eq '(Dir)');
    $gui{entrySharedFolderPath}->set_text($location) if ($location);
}

sub handle_vboxfilechooser() {
    my ($location, $filearrayref) = @_;
    my $file = ${$filearrayref}[0]->{FileName};
    my $type = ${$filearrayref}[0]->{Type};

    # We only care about the first file, there should only be one anyway
    # double check there's a file, it's not .. and it's a vbox
    if ($file and $file ne '..' and $type eq '.vbox') {
        my $IMachine = IVirtualBox_openMachine($gui{websn}, "$location/$file");
        if ($IMachine) {
            IVirtualBox_registerMachine($gui{websn}, $IMachine);
            &addrow_log("Imported guest from $location/$file");
            &fill_list_guest();
        }
        else { &addrow_log("Failed to import guest from $location/$file"); }
    }
}

# Sets up the file chooser for selecting a BMP files
sub show_bioslogofilechooser {
    my ($widget) = @_;
    $gui{dialogRemoteFileChooser}->set_transient_for($gui{dialogEdit});
    $gui{dialogRemoteFileChooser}->set_title("Choose BIOS logo on $endpoint");
    my $basedir = $gui{entryEditSysLogoPath}->get_text();
    if ($basedir) { (undef, $basedir, undef) = fileparse($basedir); }
    $chooser{filter} = '^.*\.bmp$'; # Only select .bmp files
    $chooser{handler} = \&handle_bioslogofilechooser;
    $chooser{selector} = 'GTK_SELECTION_SINGLE';
    &show_remotefilechooser_window($basedir);
}

# Sets up the file chooser for selecting a VBOX file
sub show_vboxfilechooser {
    my ($widget) = @_;
    $gui{dialogRemoteFileChooser}->set_transient_for($gui{windowMain});
    $gui{dialogRemoteFileChooser}->set_title("Choose guest to add on $endpoint");
    $chooser{filter} = '^.*\.vbox$'; # Only select .vbox files
    $chooser{handler} = \&handle_vboxfilechooser;
    $chooser{selector} = 'GTK_SELECTION_SINGLE';
    &show_remotefilechooser_window();
}

# Sets up the file chooser for selecting a medium (or any file actually)
sub show_vmmfilechooser() {
    my ($widget) = @_;
    $gui{dialogRemoteFileChooser}->set_transient_for($gui{dialogVMM});
    $gui{dialogRemoteFileChooser}->set_title("Choose Media Image on $endpoint");
    $chooser{filter} = '.*'; # Allow any file in the list
    $chooser{handler} = \&vmm_add;
    $chooser{selector} = 'GTK_SELECTION_MULTIPLE';
    &show_remotefilechooser_window();
}

# Sets up the file chooser for selecting the default machine directory
sub show_machinefolderchooser() {
    $gui{dialogRemoteFileChooser}->set_transient_for($gui{dialogVBPrefs});
    $gui{dialogRemoteFileChooser}->set_title("Choose Machine Folder on $endpoint");
    $chooser{filter} = ' ^'; # Effectively won't match any files, listing directories only
    $chooser{handler} = \&handle_machinefolderchooser;
    $chooser{selector} = 'GTK_SELECTION_SINGLE';
    &show_remotefilechooser_window($gui{entryVBPrefsGenDefMachineFolder}->get_text());
}

# Sets up the file chooser for selecting a shared folder
sub show_sharedfolderchooser() {
    $gui{dialogRemoteFileChooser}->set_transient_for($gui{dialogShared});
    $gui{dialogRemoteFileChooser}->set_title("Choose Shared Folder on $endpoint");
    $chooser{filter} = ' ^'; # Effectively won't match any files, listing directories only
    $chooser{handler} = \&handle_sharedfolderchooser;
    $chooser{selector} = 'GTK_SELECTION_SINGLE';
    &show_remotefilechooser_window($gui{entrySharedFolderPath}->get_text());
}

sub show_remotefilechooser_window() {
    my ($basedir) = @_;
    if (!$basedir) { $basedir = $hostspec{machinedir}; }
    &transwin_sens_off($gui{dialogRemoteFileChooser});
    my $IAppliance = IVirtualBox_createAppliance($gui{websn});
    $gui{IVFSExplorer} = IAppliance_createVFSExplorer($IAppliance, "file://$basedir");
    &fill_list_remotefiles($basedir);
    $gui{treeviewRemoteFileChooser}->get_selection->set_mode($chooser{selector}) if ($chooser{selector});
    my $response = $gui{dialogRemoteFileChooser}->run();
    $gui{dialogRemoteFileChooser}->hide();
    IManagedObjectRef_release($gui{IVFSExplorer});
    IManagedObjectRef_release($IAppliance);

    if ($response eq 'ok') {
        my $filearrayref = &getsel_list_remotefiles();
        my $location = $gui{entryRemoteFileChooserLocation}->get_text();
        &{$chooser{handler}}($location, $filearrayref, $chooser{userdata});
    }

    &transwin_sens_on($gui{dialogRemoteFileChooser});
}

sub refresh_remotefilechooser() { &fill_list_remotefiles($gui{entryRemoteFileChooserLocation}->get_text()); }

sub cdup_remotefilechooser() {
    IVFSExplorer_cdUp($gui{IVFSExplorer});
    &fill_list_remotefiles(IVFSExplorer_getPath($gui{IVFSExplorer}));
}

# Display a progress window for tasks which can take a long time
sub show_progress_window() {
    my ($IProgress, $msg, $cancel, $transwin) = @_;
    my $resultcode = 0;
    my $timer = 0;
    $gui{labelProgress}->set_text($msg);
    $gui{dialogProgress}->set_title($msg);
    $gui{dialogProgress}->set_transient_for($transwin) if ($transwin);
    $gui{progressbar}->set_fraction(0);

    if ($cancel) { $gui{buttonProgressCancel}->show(); }
    else { $gui{buttonProgressCancel}->hide(); }

    $timer = Glib::Timeout->add(1000,
        sub {
            my $percent = IProgress_getPercent($IProgress);

            if (IProgress_getCompleted($IProgress) eq 'true') {
                Glib::Source->remove($timer);
                $timer = 0;
                $gui{progressbar}->set_fraction(1.00);
                Gtk2->main_iteration() while Gtk2->events_pending();
                $resultcode = IProgress_getResultCode($IProgress);
                $gui{dialogProgress}->response('ok');
                return 0;
            }
            else {
                $gui{progressbar}->set_fraction($percent * 0.01);
                return 1;
            }
        });

    $gui{dialogProgress}->run();
    $gui{dialogProgress}->hide();
    Glib::Source->remove($timer) if ($timer);
    return $resultcode;
}

# Save RemoteBox's window position for restoration later
sub save_window_pos() {
    my ($winname) = @_;
    my $alloc = $gui{$winname}->allocation;
    my ($w, $h) = ($alloc->width, $alloc->height);
    my ($x,$y) = $gui{$winname}->get_position();
    $prefs{"WINPOS_$winname"} = "$w:$h:$x:$y";
    &rbprefs_save();
}

# Restore RemoteBox's window position to the last save position
sub restore_window_pos() {
    my ($winname) = @_;

    if ($prefs{"WINPOS_$winname"}) {
        my ($w, $h, $x, $y) = split ':', $prefs{"WINPOS_$winname"};
        $gui{$winname}->move($x, $y);
        $gui{$winname}->resize($w, $h);
    }
}

# Works around a 'quirk/bug' in VB where the IProgress is destroyed as the
# session is automatically closed meaning we can't use normal methods for
# monitoring operations
sub show_progress_window2() {
    my ($IProgress, $msg, $transwin, $IMachine, $finalstate) = @_;
    my $timer = 0;
    $gui{dialogProgress2}->set_title($msg);
    $gui{dialogProgress2}->set_transient_for($transwin) if ($transwin);
    $gui{progressbar2}->set_text($msg);

    $timer = Glib::Timeout->add(500,
        sub {
            if (IMachine_getState($IMachine) eq $finalstate) {
                Glib::Source->remove($timer);
                $timer = 0;
                $gui{dialogProgress2}->response('ok');
                return 0;
            }
            else {
                $gui{progressbar2}->pulse();
                return 1;
            }
        });

    $gui{dialogProgress2}->run();
    $gui{dialogProgress2}->hide();
    Glib::Source->remove($timer) if ($timer);
}

# Permit certain chars only for a guest name
sub validate_name() {
    my ($entry, $char, $len, $pos) = @_;
    $char =~ s/[\?\/\;\*\\\<\>\|\.]//; # Strip these chars
    return $char, $pos;
}

# Permit only hexadecimal in an entry
sub validate_hex() {
    my ($entry, $char, $len, $pos) = @_;
    $char =~ s/[^A-F0-9a-f]//; # Strip everything but these chars
    return $char, $pos;
}

# Permit only valid numbers for a port entry
sub validate_port() {
    my ($entry, $char, $len, $pos) = @_;
    $char =~ s/[^0-9,-]//; # Strip everything but these chars
    return $char, $pos;
}

# Permit only numbers in an entry
sub validate_number() {
    my ($entry, $char, $len, $pos) = @_;
    $char =~ s/[^0-9]//; # Strip everything but these chars
    return $char, $pos;
}

# Permit only valid chars in an IPV4 entry
sub validate_ip() {
    my ($entry, $char, $len, $pos) = @_;
    $char =~ s/[^0-9,.]//; # Strip everything but these chars
    return $char, $pos;
}

# Permit only valid chars in an IPV6 entry
sub validate_ipv6() {
    my ($entry, $char, $len, $pos) = @_;
    $char =~ s/[^A-F0-9a-f,:]//; # Strip everything but these chars
    return $char, $pos;
}

sub combobox_set_active_text {
    my ($combobox, $text) = @_;
    my $i = -1;
    $combobox->get_model->foreach (
                            sub {
                                my ($model, $path, $iter) = @_;
                                if ($text eq $model->get_value ($iter, 0)) {
                                    ($i) = $path->get_indices;
                                    return 1; # stop
                                }
                                return 0; # continue
                            }
                          );
    $combobox->set_active($i);
}

# Adds appropriate units to a spinbox when specifying memory or disk
sub spinbox_units() {
    my ($widget) = @_;
    my $adjustment = $widget->get_adjustment();
    my $adjval = int($adjustment->get_value());
    my $txt;

    if ($adjval < 1024) {
        $adjustment->step_increment(1.00);
        $txt = "$adjval MB";
    }
    elsif ($adjval < 1048576) {
        $adjustment->step_increment(10.25);
        $adjval /= 1024;
        $txt = sprintf('%0.2f GB', $adjval);
    }
    else {
        $adjustment->step_increment(10486);
        $adjval /= 1048576;
        $txt = sprintf('%0.2f TB', $adjval);
    }

    $widget->set_text($txt);
    return 1;
}

# Adds appropriate units to a spinbox when specifying time
sub spinbox_units_time() {
    my ($widget) = @_;
    my $adjustment = $widget->get_adjustment();
    my $adjval = int($adjustment->get_value());
    my $txt;

    if ($adjval < 1000) {
        $adjustment->step_increment(1.00);
        $txt = "$adjval ms";
    }
    elsif ($adjval < 60000) {
        $adjustment->step_increment(10.00);
        $adjval /= 1000;
        $txt = sprintf('%0.2f secs', $adjval);
    }
    else {
        $adjustment->step_increment(600.00);
        $adjval /= 60000;
        $txt = sprintf('%0.2f mins', $adjval);
    }

    $widget->set_text($txt);
    return 1;
}

# Adds appropriate units to a spinbox when specifying percent
sub spinbox_units_pc() {
    my ($widget) = @_;
    my $adjustment = $widget->get_adjustment();
    my $adjval = int($adjustment->get_value());
    $widget->set_text($adjval . '%');
    return 1;
}

# Callback set on a timer to attempt to keep the connection alive, even in the
# case where a user has set a timeout. This callback needs to be cheap
sub heartbeat() {
    IVirtualBox_getVersion($gui{websn}) if ($gui{websn});
    return 1; # Return 1 to stop the timer from being removed
}

1;
