# Edit Network Settings of a Guest
use strict;
use warnings;
our (%gui, %signal, %bool, %vmc);

sub setup_edit_dialog_network() {
    &addrow_log("Retrieving network settings for $vmc{Name}...");
    &busy_pointer($gui{dialogEdit}, 1);
    $gui{comboboxEditNetType1}->signal_handler_block($signal{netadaptype1});
    $gui{comboboxEditNetType2}->signal_handler_block($signal{netadaptype2});
    $gui{comboboxEditNetType3}->signal_handler_block($signal{netadaptype3});
    $gui{comboboxEditNetType4}->signal_handler_block($signal{netadaptype4});
    $gui{comboboxEditNetAttach1}->signal_handler_block($signal{netattach1});
    $gui{comboboxEditNetAttach2}->signal_handler_block($signal{netattach2});
    $gui{comboboxEditNetAttach3}->signal_handler_block($signal{netattach3});
    $gui{comboboxEditNetAttach4}->signal_handler_block($signal{netattach4});
    $gui{comboboxEditNetName1}->signal_handler_block($signal{netname1});
    $gui{comboboxEditNetName2}->signal_handler_block($signal{netname2});
    $gui{comboboxEditNetName3}->signal_handler_block($signal{netname3});
    $gui{comboboxEditNetName4}->signal_handler_block($signal{netname4});
    $gui{comboboxentryEditNetGenDriver1}->signal_handler_block($signal{genericdrv1});
    $gui{comboboxentryEditNetGenDriver2}->signal_handler_block($signal{genericdrv2});
    $gui{comboboxentryEditNetGenDriver3}->signal_handler_block($signal{genericdrv3});
    $gui{comboboxentryEditNetGenDriver4}->signal_handler_block($signal{genericdrv4});
    $gui{comboboxentryEditNetNameInt1}->signal_handler_block($signal{nameint1});
    $gui{comboboxentryEditNetNameInt2}->signal_handler_block($signal{nameint2});
    $gui{comboboxentryEditNetNameInt3}->signal_handler_block($signal{nameint3});
    $gui{comboboxentryEditNetNameInt4}->signal_handler_block($signal{nameint4});

    foreach ($gui{liststoreEditNetName1}, $gui{liststoreEditNetName2}, $gui{liststoreEditNetName3},
             $gui{liststoreEditNetName4}, $gui{liststoreEditNetGenDriver}, $gui{liststoreEditNetNameInt}) {
        $_->clear();
    }

    my $IHost = IVirtualBox_getHost($gui{websn});

    foreach my $slot (1..4) {
        my $INetworkAdapter = IMachine_getNetworkAdapter($vmc{IMachine}, $slot-1);
        my $AttachType = INetworkAdapter_getAttachmentType($INetworkAdapter);
        my @IHostNetworkInterface = IHost_getNetworkInterfaces($IHost);
        $gui{'checkbuttonEditNetEnable' . $slot}->set_active($bool{INetworkAdapter_getEnabled($INetworkAdapter)});
        my $netenabled = $gui{'checkbuttonEditNetEnable' . $slot}->get_active();
        $gui{'tableEditNet' . $slot}->set_sensitive($netenabled); # Ghost/Unghost other widgets based on net enabled
        $gui{'tableEditNetAdv' . $slot}->set_sensitive($netenabled);
        $gui{'labelExpanderEditNet' . $slot}->set_sensitive($netenabled);
        $gui{'checkbuttonEditNetCable' . $slot}->set_active($bool{INetworkAdapter_getCableConnected($INetworkAdapter)});
        $gui{'entryEditNetMac' . $slot}->set_text(INetworkAdapter_getMACAddress($INetworkAdapter));
        &combobox_set_active_text($gui{'comboboxEditNetType' . $slot}, INetworkAdapter_getAdapterType($INetworkAdapter));
        &combobox_set_active_text($gui{'comboboxEditNetAttach' . $slot}, $AttachType);

        if ($AttachType eq 'Bridged') { &net_gui_bridged($INetworkAdapter, $slot); }
        elsif ($AttachType eq 'HostOnly') { &net_gui_hostonly($INetworkAdapter, $slot); }
        elsif ($AttachType eq 'Internal') { &net_gui_internal($INetworkAdapter, $slot); }
        elsif ($AttachType eq 'Generic') { &net_gui_generic($INetworkAdapter, $slot); }
        elsif ($AttachType eq 'NAT') { &net_gui_nat($INetworkAdapter, $slot); }
        else { &net_gui_notattached($INetworkAdapter, $slot); } # Assume Null
    }

    $gui{comboboxEditNetType1}->signal_handler_unblock($signal{netadaptype1});
    $gui{comboboxEditNetType2}->signal_handler_unblock($signal{netadaptype2});
    $gui{comboboxEditNetType3}->signal_handler_unblock($signal{netadaptype3});
    $gui{comboboxEditNetType4}->signal_handler_unblock($signal{netadaptype4});
    $gui{comboboxEditNetAttach1}->signal_handler_unblock($signal{netattach1});
    $gui{comboboxEditNetAttach2}->signal_handler_unblock($signal{netattach2});
    $gui{comboboxEditNetAttach3}->signal_handler_unblock($signal{netattach3});
    $gui{comboboxEditNetAttach4}->signal_handler_unblock($signal{netattach4});
    $gui{comboboxEditNetName1}->signal_handler_unblock($signal{netname1});
    $gui{comboboxEditNetName2}->signal_handler_unblock($signal{netname2});
    $gui{comboboxEditNetName3}->signal_handler_unblock($signal{netname3});
    $gui{comboboxEditNetName4}->signal_handler_unblock($signal{netname4});
    $gui{comboboxentryEditNetGenDriver1}->signal_handler_unblock($signal{genericdrv1});
    $gui{comboboxentryEditNetGenDriver2}->signal_handler_unblock($signal{genericdrv2});
    $gui{comboboxentryEditNetGenDriver3}->signal_handler_unblock($signal{genericdrv3});
    $gui{comboboxentryEditNetGenDriver4}->signal_handler_unblock($signal{genericdrv4});
    $gui{comboboxentryEditNetNameInt1}->signal_handler_unblock($signal{nameint1});
    $gui{comboboxentryEditNetNameInt2}->signal_handler_unblock($signal{nameint2});
    $gui{comboboxentryEditNetNameInt3}->signal_handler_unblock($signal{nameint3});
    $gui{comboboxentryEditNetNameInt4}->signal_handler_unblock($signal{nameint4});
    &busy_pointer($gui{dialogEdit}, 0);
    &addrow_log("Network settings for $vmc{Name} retrieved.");
}

sub net_toggle() {
    my ($widget, $checkbutton) = @_;
    my $state = $widget->get_active();
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    INetworkAdapter_setEnabled($INetworkAdapter, $state);
    $gui{'tableEditNet' . $num}->set_sensitive($state);
    $gui{'tableEditNetAdv' . $num}->set_sensitive($state);
    $gui{'labelExpanderEditNet' . $num}->set_sensitive($state);
}

# Sets whether the virtual network cable is plugged in or not
sub net_cable() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    INetworkAdapter_setCableConnected($INetworkAdapter, $widget->get_active());
}

# Sets whether the network adapter in the VM is allowed to enter promiscuous mode
sub net_promiscuous() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    INetworkAdapter_setPromiscModePolicy($INetworkAdapter, &getsel_combo($gui{'comboboxEditNetPromiscuous' . $num}, 0));
}

sub net_mac() {
    my ($widget, $focus, $checkbutton) = @_;
    $checkbutton = $focus if (!$checkbutton);
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $mac = $widget->get_text();
    INetworkAdapter_setMACAddress($INetworkAdapter, $mac) if (length($mac) == 12);
}

sub net_generic_driver() {
    my ($widget, $focus, $checkbutton) = @_;
    $checkbutton = $focus if (!$checkbutton);
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $genericdriver = $widget->get_active_text();
    INetworkAdapter_setGenericDriver($INetworkAdapter, $genericdriver) if ($genericdriver);
}

# Sets the generic drivers properties from the textview
sub net_generic_properties() {
    my ($widget, $focus, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my @cprops = INetworkAdapter_getProperties($INetworkAdapter, 0); #It Returns a single array. First half is keys, second is values

    # Clear out all properties before adding the new ones
    if (scalar(@cprops) > 0) {
        foreach (0 .. int(@cprops / 2) - 1) { INetworkAdapter_setProperty($INetworkAdapter, $cprops[$_], ''); }
    }

    my $textbuffer = $gui{'textbufferEditNetGeneric' . $num};
    my $count = $textbuffer->get_line_count();

    foreach my $linenum (0 .. ($count - 1)) {
        my $iter_s = $textbuffer->get_iter_at_line($linenum);
        my $iter_e;
        $iter_e = ($linenum == ($count - 1)) ? $textbuffer->get_end_iter() : $textbuffer->get_iter_at_line($linenum + 1);
        my $line = $textbuffer->get_text($iter_s, $iter_e, 0);
        chomp($line);
        $line =~ m/^(.*)=(.*)$/; # match against equals
        my $key = $1;
        my $value = $2;
        $line =~ s/^\s+//; #remove leading spaces
        $line =~ s/\s+$//; #remove trailing spaces
        INetworkAdapter_setProperty($INetworkAdapter, $key, $value) if ($key and $value);
    }
}

sub net_adapter_type() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $type = &getsel_combo($widget, 0);
    INetworkAdapter_setAdapterType($INetworkAdapter, $type);
}

sub net_attach() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    $gui{'comboboxEditNetName' . $num}->signal_handler_block($signal{'netname' . $num});
    $gui{'comboboxentryEditNetGenDriver' . $num}->signal_handler_block($signal{'genericdrv' . $num});
    $gui{'comboboxentryEditNetNameInt' . $num}->signal_handler_block($signal{'nameint' . $num});
    my $IHost = IVirtualBox_getHost($gui{websn});
    my $AttachType = &getsel_combo($widget, 0);
    $gui{'liststoreEditNetName' . $num}->clear();
    INetworkAdapter_setAttachmentType($INetworkAdapter, $AttachType);

    if ($AttachType eq 'Bridged') { &net_gui_bridged($INetworkAdapter, $num); }
    elsif ($AttachType eq 'HostOnly') { &net_gui_hostonly($INetworkAdapter, $num); }
    elsif ($AttachType eq 'Internal') { &net_gui_internal($INetworkAdapter, $num); }
    elsif ($AttachType eq 'NAT') { &net_gui_nat($INetworkAdapter, $num); }
    elsif ($AttachType eq 'Generic') { &net_gui_generic($INetworkAdapter, $num); }
    else { &net_gui_notattached($INetworkAdapter, $num); }

    $gui{'comboboxentryEditNetGenDriver' . $num}->signal_handler_unblock($signal{'genericdrv' . $num});
    $gui{'comboboxentryEditNetNameInt' . $num}->signal_handler_unblock($signal{'nameint' . $num});
    $gui{'comboboxEditNetName' . $num}->signal_handler_unblock($signal{'netname' . $num});
    $gui{'comboboxEditNetName' . $num}->set_active(0); # This will call net_name()
}

sub net_name() {
    my ($widget, $checkbutton) = @_;
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $AttachType = &getsel_combo($gui{'comboboxEditNetAttach' . $num}, 0);

    if ($AttachType eq 'Bridged') { INetworkAdapter_setBridgedInterface($INetworkAdapter, $gui{'comboboxEditNetName' . $num}->get_active_text()); }
    elsif ($AttachType eq 'HostOnly') { INetworkAdapter_setHostOnlyInterface($INetworkAdapter, $gui{'comboboxEditNetName' . $num}->get_active_text()); }
}

sub net_name_internal() {
    my ($widget, $focus, $checkbutton) = @_;
    $checkbutton = $focus if (!$checkbutton);
    my ($INetworkAdapter, $num) = &callout_getnetadapter($checkbutton);
    my $name = $widget->get_active_text();
    INetworkAdapter_setInternalNetwork($INetworkAdapter, $name) if ($name);
}

sub callout_getnetadapter() {
    my ($checkbutton) = @_;
    my $slot = 0;
    if ($checkbutton eq $gui{checkbuttonEditNetEnable1}) { $slot = 0; }
    elsif ($checkbutton eq $gui{checkbuttonEditNetEnable2}) { $slot = 1; }
    elsif ($checkbutton eq $gui{checkbuttonEditNetEnable3}) { $slot = 2; }
    elsif ($checkbutton eq $gui{checkbuttonEditNetEnable4}) { $slot = 3; }
    my $INetworkAdapter = IMachine_getNetworkAdapter($vmc{IMachine}, $slot);
    return $INetworkAdapter, $slot+1;
}

# Handle hiding and unhiding gui components based on attachment type
sub net_gui_bridged() {
    my ($INetworkAdapter, $num) = @_;
    my $IHost = IVirtualBox_getHost($gui{websn});
    my @IHostNetworkInterface = IHost_getNetworkInterfaces($IHost);
    my $bridgeface = INetworkAdapter_getBridgedInterface($INetworkAdapter);

    foreach my $interface (@IHostNetworkInterface) {
        if (IHostNetworkInterface_getInterfaceType($interface) eq 'Bridged') {
            my $name = IHostNetworkInterface_getName($interface);
            my $iter = $gui{'liststoreEditNetName' . $num}->append();
            $gui{'liststoreEditNetName' . $num}->set($iter, 0, $name);
            $gui{'comboboxEditNetName' . $num}->set_active_iter($iter) if ($name eq $bridgeface);
        }
    }

    $gui{'labelEditNetName' . $num}->show();
    $gui{'comboboxEditNetName' . $num}->show();
    $gui{'labelEditNetPromiscuous' . $num}->show();
    $gui{'comboboxEditNetPromiscuous' . $num}->show();
    $gui{'labelEditNetNameInt' . $num}->hide();
    $gui{'comboboxentryEditNetNameInt' . $num}->hide();
    $gui{'labelEditNetGenDriver' . $num}->hide();
    $gui{'comboboxentryEditNetGenDriver' . $num}->hide();
    $gui{'labelEditNetGeneric' . $num}->hide();
    $gui{'textviewEditNetGeneric' . $num}->hide();
    $gui{'buttonEditNetPortForwarding' . $num}->hide();

    my $promiscpolicy = INetworkAdapter_getPromiscModePolicy($INetworkAdapter);
    if ($promiscpolicy eq 'AllowNetwork') { $gui{'comboboxEditNetPromiscuous' . $num}->set_active(1) }
    elsif ($promiscpolicy eq 'AllowAll') { $gui{'comboboxEditNetPromiscuous' . $num}->set_active(2) }
    else { $gui{'comboboxEditNetPromiscuous' . $num}->set_active(0); }

}

sub net_gui_notattached() {
    my ($INetworkAdapter, $num) = @_;
    $gui{'labelEditNetName' . $num}->hide();
    $gui{'comboboxEditNetName' . $num}->hide();
    $gui{'labelEditNetNameInt' . $num}->hide();
    $gui{'comboboxentryEditNetNameInt' . $num}->hide();
    $gui{'labelEditNetGenDriver' . $num}->hide();
    $gui{'comboboxentryEditNetGenDriver' . $num}->hide();
    $gui{'labelEditNetPromiscuous' . $num}->hide();
    $gui{'comboboxEditNetPromiscuous' . $num}->hide();
    $gui{'labelEditNetGeneric' . $num}->hide();
    $gui{'textviewEditNetGeneric' . $num}->hide();
    $gui{'buttonEditNetPortForwarding' . $num}->hide();
}

sub net_gui_hostonly() {
    my ($INetworkAdapter, $num) = @_;
    my $IHost = IVirtualBox_getHost($gui{websn});
    my @IHostNetworkInterface = IHost_getNetworkInterfaces($IHost);
    my $hostonlyface = INetworkAdapter_getHostOnlyInterface($INetworkAdapter);

    foreach my $interface (@IHostNetworkInterface) {
        if (IHostNetworkInterface_getInterfaceType($interface) eq 'HostOnly') {
            my $name = IHostNetworkInterface_getName($interface);
            my $iter = $gui{'liststoreEditNetName' . $num}->append();
            $gui{'liststoreEditNetName' . $num}->set($iter, 0, $name);
            $gui{'comboboxEditNetName' . $num}->set_active_iter($iter) if ($name eq $hostonlyface);
        }
    }

    $gui{'labelEditNetName' . $num}->show();
    $gui{'comboboxEditNetName' . $num}->show();
    $gui{'labelEditNetPromiscuous' . $num}->show();
    $gui{'comboboxEditNetPromiscuous' . $num}->show();
    $gui{'labelEditNetNameInt' . $num}->hide();
    $gui{'comboboxentryEditNetNameInt' . $num}->hide();
    $gui{'labelEditNetGenDriver' . $num}->hide();
    $gui{'comboboxentryEditNetGenDriver' . $num}->hide();
    $gui{'labelEditNetGeneric' . $num}->hide();
    $gui{'textviewEditNetGeneric' . $num}->hide();
    $gui{'buttonEditNetPortForwarding' . $num}->hide();
}

sub net_gui_internal() {
    my ($INetworkAdapter, $num) = @_;
    $gui{liststoreEditNetNameInt}->clear();
    my $name = INetworkAdapter_getInternalNetwork($INetworkAdapter);
    my @intlist = IVirtualBox_getInternalNetworks($gui{websn});

    foreach my $net (@intlist) {
        my $iter = $gui{liststoreEditNetNameInt}->append();
        $gui{liststoreEditNetNameInt}->set($iter, 0, $net);
        $gui{'comboboxentryEditNetNameInt' . $num}->set_active_iter($iter) if ($net eq $name);
    }

    $gui{'labelEditNetNameInt' . $num}->show();
    $gui{'comboboxentryEditNetNameInt' . $num}->show();
    $gui{'labelEditNetPromiscuous' . $num}->show();
    $gui{'comboboxEditNetPromiscuous' . $num}->show();
    $gui{'labelEditNetName' . $num}->hide();
    $gui{'comboboxEditNetName' . $num}->hide();
    $gui{'labelEditNetGenDriver' . $num}->hide();
    $gui{'comboboxentryEditNetGenDriver' . $num}->hide();
    $gui{'labelEditNetGeneric' . $num}->hide();
    $gui{'textviewEditNetGeneric' . $num}->hide();
    $gui{'buttonEditNetPortForwarding' . $num}->hide();
}


sub net_gui_nat() {
    my ($INetworkAdapter, $num) = @_;
    $gui{'buttonEditNetPortForwarding' . $num}->show();
    $gui{'labelEditNetName' . $num}->hide();
    $gui{'comboboxEditNetName' . $num}->hide();
    $gui{'labelEditNetNameInt' . $num}->hide();
    $gui{'comboboxentryEditNetNameInt' . $num}->hide();
    $gui{'labelEditNetGenDriver' . $num}->hide();
    $gui{'comboboxentryEditNetGenDriver' . $num}->hide();
    $gui{'labelEditNetPromiscuous' . $num}->hide();
    $gui{'comboboxEditNetPromiscuous' . $num}->hide();
    $gui{'labelEditNetGeneric' . $num}->hide();
    $gui{'textviewEditNetGeneric' . $num}->hide();
}

sub net_gui_generic() {
    my ($INetworkAdapter, $num) = @_;
    $gui{liststoreEditNetGenDriver}->clear();
    my $genericdriver = INetworkAdapter_getGenericDriver($INetworkAdapter);
    my @genericlist = IVirtualBox_getGenericNetworkDrivers($gui{websn});
    my @props = INetworkAdapter_getProperties($INetworkAdapter, 0); #It Returns a single array. First half is keys, second is values
    my $proptext;

    # Messy thanks to the way INetworkAdapter_getProperties works
    if (scalar(@props) > 0) {
        my $propnum = scalar(@props);
        my @props_vals = splice(@props, int($propnum / 2), $propnum); #grab the last half of array.
        my @props_keys = splice(@props, 0, int($propnum / 2)); #grab the first half of array.
        foreach (0 .. scalar(@props_keys) - 1) { $proptext .= "$props_keys[$_]" . '=' . "$props_vals[$_]\n"; }
    }

    $gui{'textbufferEditNetGeneric' . $num}->set_text($proptext) if ($proptext);

    foreach my $driver (@genericlist) {
            my $iter = $gui{liststoreEditNetGenDriver}->append();
            $gui{liststoreEditNetGenDriver}->set($iter, 0, $driver);
            $gui{'comboboxentryEditNetGenDriver' . $num}->set_active_iter($iter) if ($driver eq $genericdriver);
    }

    $gui{'labelEditNetGenDriver' . $num}->show();
    $gui{'comboboxentryEditNetGenDriver' . $num}->show();
    $gui{'labelEditNetGeneric' . $num}->show();
    $gui{'textviewEditNetGeneric' . $num}->show();
    $gui{'labelEditNetName' . $num}->hide();
    $gui{'comboboxEditNetName' . $num}->hide();
    $gui{'labelEditNetNameInt' . $num}->hide();
    $gui{'comboboxentryEditNetNameInt' . $num}->hide();
    $gui{'labelEditNetPromiscuous' . $num}->hide();
    $gui{'comboboxEditNetPromiscuous' . $num}->hide();
    $gui{'buttonEditNetPortForwarding' . $num}->hide();
}

sub net_portforward() {
    &show_err_msg('noportforward', $gui{messagedialogWarning});
}

1;