# Serializers for missing datatypes in vboxService
use strict;
use warnings;

sub SOAP::Serializer::as_HWVirtExPropertyType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:HWVirtExPropertyType', %$attr}, $value];
}

sub SOAP::Serializer::as_DeviceType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:DeviceType', %$attr}, $value];
}

sub SOAP::Serializer::as_RuntimeFault {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:RuntimeFault', %$attr}, $value];
}

sub SOAP::Serializer::as_CPUPropertyType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:CPUPropertyType', %$attr}, $value];
}

sub SOAP::Serializer::as_FirmwareType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:FirmwareType', %$attr}, $value];
}

sub SOAP::Serializer::as_AudioControllerType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AudioControllerType', %$attr}, $value];
}

sub SOAP::Serializer::as_AudioDriverType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AudioDriverType', %$attr}, $value];
}

sub SOAP::Serializer::as_NetworkAdapterType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:NetworkAdapterType', %$attr}, $value];
}

sub SOAP::Serializer::as_StorageBus {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:StorageBus', %$attr}, $value];
}

sub SOAP::Serializer::as_StorageControllerType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:StorageControllerType', %$attr}, $value];
}

sub SOAP::Serializer::as_AccessMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AccessMode', %$attr}, $value];
}

sub SOAP::Serializer::as_PointingHidType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:PointingHidType', %$attr}, $value];
}

sub SOAP::Serializer::as_KeyboardHidType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:KeyboardHidType', %$attr}, $value];
}

sub SOAP::Serializer::as_AuthType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:AuthType', %$attr}, $value];
}

sub SOAP::Serializer::as_PortMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:PortMode', %$attr}, $value];
}

sub SOAP::Serializer::as_ClipboardMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:ClipboardMode', %$attr}, $value];
}

sub SOAP::Serializer::as_HostNetworkInterfaceType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:HostNetworkInterfaceType', %$attr}, $value];
}

sub SOAP::Serializer::as_LockType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:LockType', %$attr}, $value];
}

sub SOAP::Serializer::as_CleanupMode {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:CleanupMode', %$attr}, $value];
}

sub SOAP::Serializer::as_ChipsetType {
    my $self = shift;
    my ($value, $name, $type, $attr) = @_;
    return [$name, {'xsi:type' => 'vbox:ChipsetType', %$attr}, $value];
}

1;