# Edit Storage Settings of a Guest
use strict;
use warnings;
our (%gui, %signal, %hostspec, %bool, %EMedVar, %vmc);

sub setup_edit_dialog_storage() {
    &busy_window($gui{dialogEdit}, 0, 'watch');
    &fill_list_editstorage($vmc{IMachine});
    $gui{menuAttachAdd} = Gtk2::Menu->new();
    $gui{menuAttachHD} = Gtk2::Menu->new();
    $gui{menuAttachDVD} = Gtk2::Menu->new();
    $gui{menuAttachFloppy} = Gtk2::Menu->new();
    $gui{menuitemAttachHD} = Gtk2::MenuItem->new_with_label('Hard Disks');
    $gui{menuitemAttachDVD} = Gtk2::MenuItem->new_with_label('CDs/DVDs');
    $gui{menuitemAttachFloppy} = Gtk2::MenuItem->new_with_label('Floppy Disks');
    $gui{menuitemAttachHD}->set_submenu($gui{menuAttachHD});
    $gui{menuitemAttachDVD}->set_submenu($gui{menuAttachDVD});
    $gui{menuitemAttachFloppy}->set_submenu($gui{menuAttachFloppy});
    $gui{menuitemAttachHD}->show();
    $gui{menuitemAttachDVD}->show();
    $gui{menuitemAttachFloppy}->show();
    $gui{menuAttachAdd}->append($gui{menuitemAttachHD});
    $gui{menuAttachAdd}->append($gui{menuitemAttachDVD});
    $gui{menuAttachAdd}->append($gui{menuitemAttachFloppy});
    my $newhditem = Gtk2::MenuItem->new_with_label('Create New HardDisk');
    $gui{menuAttachHD}->append($newhditem);
    $newhditem->show();
    $newhditem->signal_connect(activate => \&show_createhd_dialog);
    my $sep = Gtk2::SeparatorMenuItem->new();
    $gui{menuAttachHD}->append($sep);
    $sep->show();

    my $IMediumHDRef = &get_all_media('HardDisk');
    my $IMediumDVDRef = &get_all_media('DVD');
    my $IMediumFloppyRef = &get_all_media('Floppy');

    foreach (sort { lc($a) cmp lc($b) } (keys %$IMediumHDRef)) {
        my $item = Gtk2::MenuItem->new_with_label($_);
        $gui{menuAttachHD}->append($item);
        $item->show();
        $item->signal_connect(activate => \&storage_attach_add, $$IMediumHDRef{$_});
    }

    foreach (sort { lc($a) cmp lc($b) } (keys %$IMediumDVDRef)) {
        my $item = Gtk2::MenuItem->new_with_label($_);
        $gui{menuAttachDVD}->append($item);
        $item->show();
        $item->signal_connect(activate => \&storage_attach_add, $$IMediumDVDRef{$_});
    }

    foreach (sort { lc($a) cmp lc($b) } (keys %$IMediumFloppyRef)) {
        my $item = Gtk2::MenuItem->new_with_label($_);
        $gui{menuAttachFloppy}->append($item);
        $item->show();
        $item->signal_connect(activate => \&storage_attach_add, $$IMediumFloppyRef{$_});
    }

    &busy_window($gui{dialogEdit}, 1, undef);
}

sub show_createhd_dialog() {
    my $guestname = IMachine_getName($vmc{IMachine});
    $gui{entryCreateHDName}->set_text($guestname . int(rand(9999)));
    $gui{spinbuttonCreateHDSize}->set_range(8.00, int($hostspec{maxhdsize}/1048576));
    $gui{spinbuttonCreateHDSize}->set_value(8192.00);
    my $response = $gui{dialogCreateHD}->run;
    $gui{dialogCreateHD}->hide;
    my $diskname = $gui{entryCreateHDName}->get_text();
    $diskname =~ s/\.vdi$//;
    my $disksize = $gui{spinbuttonCreateHDSize}->get_value_as_int() * 1048576;

    if ($diskname and ($response eq 'ok')) {
        my $IMedium;
        my $location = &get_path_only(IMachine_getSettingsFilePath($vmc{IMachine}));

        if ($gui{checkbuttonCreateHDDynamic}->get_active()) { $IMedium = &create_new_hd($diskname, $location, 'vdi', $EMedVar{Standard}, $disksize, $gui{dialogEdit}); }
        else { $IMedium = &create_new_hd($diskname, $location, 'vdi', $EMedVar{Fixed}, $disksize, $gui{dialogEdit}); }

        &storage_attach_add(undef, $IMedium);
    }
}

sub storage_ctr_add() {
    my ($widget) = @_;
    my $bus = 'Floppy'; # Assume floppy unless set otherwise

    if ($widget eq $gui{menuitemCtrAddIDE}) { $bus = 'IDE'; }
    elsif ($widget eq $gui{menuitemCtrAddSCSI}) { $bus = 'SCSI'; }
    elsif ($widget eq $gui{menuitemCtrAddSATA}) { $bus = 'SATA'; }
    elsif ($widget eq $gui{menuitemCtrAddSAS}) { $bus = 'SAS'; }

    my @IStorageController = IMachine_getStorageControllers($vmc{IMachine});
    my $exists = 0;

    foreach my $ctr (@IStorageController) { $exists = 1 if (IStorageController_getBus($ctr) eq $bus) }

    if (!$exists) {
        IMachine_addStorageController($vmc{IMachine}, "$bus Controller", $bus);
        &fill_list_editstorage($vmc{IMachine});
    }
    elsif ($exists) { &show_err_msg('ctrallocated', $gui{messagedialogError}); }
}

sub storage_attach_add() {
    my ($widget, $IMedium) = @_;
    my $storref = &getsel_list_editstorage();

    # Check if the item is a controller or DVD/Floppy device
    if ($$storref{Type} eq 'DVD') {
        IMachine_mountMedium($vmc{IMachine}, $$storref{Controllernameformedia}, $$storref{Port}, $$storref{Devnum}, $IMedium);
    }
    elsif ($$storref{Type} eq 'Floppy') {
        IMachine_mountMedium($vmc{IMachine}, $$storref{Controllernameformedia}, $$storref{Port}, $$storref{Devnum}, $IMedium);
    }
    else {
        my $mtype = IMedium_getDeviceType($IMedium);
        my ($freedev, $freeport) = &get_free_deviceport($vmc{IMachine}, $$storref{IObject});
        my @IMediumAttachment = IMachine_getMediumAttachmentsOfController($vmc{IMachine}, $$storref{Name});
        my $attached = 0;

        # Check for an empty Floppy/DVD first and try an use that (if medium appropriate)
        if ($mtype eq 'DVD') {
            foreach my $attach (@IMediumAttachment) {
                next if ($$attach{medium}); # We ignore if it already has a medium
                next if ($$attach{type} ne 'DVD'); # Only interested in DVD devices
                IMachine_mountMedium($vmc{IMachine}, $$storref{Name}, $$attach{port}, $$attach{device}, $IMedium);
                $attached = 1;
            }
        }
        elsif ($mtype eq 'Floppy') {
            foreach my $attach (@IMediumAttachment) {
                next if ($$attach{medium}); # We ignore if it already has a medium
                next if ($$attach{type} ne 'Floppy'); # Only interested in DVD devices
                IMachine_mountMedium($vmc{IMachine}, $$storref{Name}, $$attach{port}, $$attach{device}, $IMedium);
                $attached = 1;
            }

        }

        # For non removable media or if no empty Floppy/DVD, then add new attachment
        if ($attached == 0) {
            if ($freedev ne -1) {
                &create_sas_sata_port($$storref{IObject}); # Harmless if not SAS/SATA controller
                IMachine_attachDevice($vmc{IMachine}, $$storref{Name}, $freeport, $freedev, $mtype, $IMedium);
                $attached = 1
            }
        }

        # If medium wasn't attached, controller must be full
        if (!$attached) { &show_err_msg('ctrfull', $gui{messagedialogError}); }
    }

    &fill_list_editstorage($vmc{IMachine});
}

sub storage_attach_rem() {
    my $storref = &getsel_list_editstorage();
    # Unmount removable media, otherwise remove device for everything.
    if ((($$storref{Type} eq 'Floppy') or ($$storref{Type} eq 'DVD')) and ($$storref{IObject} ne '<empty>')) {
        IMachine_mountMedium($vmc{IMachine}, $$storref{Controllernameformedia}, $$storref{Port}, $$storref{Devnum}, '');
    }
    else { IMachine_detachDevice($vmc{IMachine}, $$storref{Controllernameformedia}, $$storref{Port}, $$storref{Devnum}); }

    &fill_list_editstorage($vmc{IMachine});
}

sub storage_ctr_rem() {
    my $storref = &getsel_list_editstorage();
    my @IMediumAttachments = IMachine_getMediumAttachmentsOfController($vmc{IMachine}, $$storref{Name});

    if (@IMediumAttachments) { &show_err_msg('ctrinuse', $gui{messagedialogWarning}); }
    else { IMachine_removeStorageController($vmc{IMachine}, $$storref{Name}); }

    &fill_list_editstorage($vmc{IMachine});
}

sub storage_ctrtype_fill() {
    my ($ctype, $IStorCtr) = @_;
    $gui{comboboxEditStorCtrType}->signal_handler_block($signal{stortype});
    $gui{liststoreEditStorCtrType}->clear();
    my $cvariant = IStorageController_getControllerType($IStorCtr);

    if ($ctype eq 'IDE Controller') {
        foreach ('PIIX3', 'PIIX4', 'ICH6') {
            my $iter = $gui{liststoreEditStorCtrType}->append();
            $gui{liststoreEditStorCtrType}->set($iter, 0, $_);
        }
    }
    elsif ($ctype eq 'SATA Controller') {
        my $iter = $gui{liststoreEditStorCtrType}->append();
        $gui{liststoreEditStorCtrType}->set($iter, 0, 'IntelAhci');
    }
    elsif ($ctype eq 'SAS Controller') {
        my $iter = $gui{liststoreEditStorCtrType}->append();
        $gui{liststoreEditStorCtrType}->set($iter, 0, 'LsiLogicSas');
    }
    elsif ($ctype eq 'SCSI Controller') {
        foreach ('LsiLogic', 'BusLogic') {
            my $iter = $gui{liststoreEditStorCtrType}->append();
            $gui{liststoreEditStorCtrType}->set($iter, 0, $_);
        }
    }
    elsif ($ctype eq 'Floppy Controller') {
        my $iter = $gui{liststoreEditStorCtrType}->append();
        $gui{liststoreEditStorCtrType}->set($iter, 0, 'I82078');
    }

    if ($cvariant eq 'ICH6') { $gui{comboboxEditStorCtrType}->set_active(2); }
    elsif ($cvariant eq 'PIIX4' || $cvariant eq 'BusLogic') { $gui{comboboxEditStorCtrType}->set_active(1); }
    else { $gui{comboboxEditStorCtrType}->set_active(0); }

    $gui{checkbuttonEditStorCache}->set_active($bool{IStorageController_getUseHostIOCache($IStorCtr)});
    $gui{comboboxEditStorCtrType}->signal_handler_unblock($signal{stortype});
}

sub storage_ctrtype() {
    my $storref = &getsel_list_editstorage();
    IStorageController_setControllerType($$storref{IObject}, &getsel_combo($gui{comboboxEditStorCtrType}, 0));
    &fill_list_editstorage($vmc{IMachine});
}

# Set/Clear the host I/O cache for the controller
sub storage_ctrcache() {
    my $storref = &getsel_list_editstorage();
    IStorageController_setUseHostIOCache($$storref{IObject}, $gui{checkbuttonEditStorCache}->get_active());
}

sub show_attach_menu() {
    my ($widget, $event) = @_;
    $gui{menuAttachAdd}->popup(undef, undef, undef, undef, 0, $event->time) if ($event->button == 1);
    return 0;
}

sub show_ctr_menu() {
    my ($widget, $event) = @_; #$event->time
    $gui{menuCtrAdd}->popup(undef, undef, undef, undef, 0, $event->time) if ($event->button == 1);
    return 0;
}

1;