# Edit Display Settings of a Guest
use strict;
use warnings;
our (%gui, %bool, %hostspec, %vmc);

sub setup_edit_dialog_display() {
    &busy_window($gui{dialogEdit}, 0, 'watch');
    $gui{spinbuttonEditDispVidMem}->set_range($hostspec{minguestvram}, $hostspec{maxguestvram});
    $gui{spinbuttonEditDispVidMem}->set_value(IMachine_getVRAMSize($vmc{IMachine}));
    $gui{spinbuttonEditDispMonitor}->set_range(1, $hostspec{maxmonitors});
    $gui{spinbuttonEditDispMonitor}->set_value(IMachine_getMonitorCount($vmc{IMachine}));
    $gui{checkbuttonEditDisp3D}->set_active($bool{IMachine_getAccelerate3DEnabled($vmc{IMachine})});
    $gui{checkbuttonEditDisp2D}->set_active($bool{IMachine_getAccelerate2DVideoEnabled($vmc{IMachine})});
    $gui{checkbuttonEditDispServer}->set_active($bool{IVRDEServer_getEnabled($vmc{IVRDEServer})});
    $gui{tableEditDispRemote}->set_sensitive($gui{checkbuttonEditDispServer}->get_active()); # Ghost/Unghost other widgets based on server enabled
    $gui{entryEditDispPort}->set_text(IVRDEServer_getVRDEProperty($vmc{IVRDEServer}, 'TCP/Ports'));
    $gui{entryEditDispAuthTime}->set_text(IVRDEServer_getAuthTimeout($vmc{IVRDEServer}));
    $gui{checkbuttonEditDispMultiple}->set_active($bool{IVRDEServer_getAllowMultiConnection($vmc{IVRDEServer})});
    # Bit hacky to work around what appears to be a bug in VB 4.0.x
    my $dispqual = IVRDEServer_getVRDEProperty($vmc{IVRDEServer}, 'VideoChannel/Quality');
    if (!$dispqual) { IVRDEServer_setVRDEProperty($vmc{IVRDEServer}, 'VideoChannel/Quality', 75); }
    $gui{spinbuttonEditDispQuality}->set_value(int(IVRDEServer_getVRDEProperty($vmc{IVRDEServer}, 'VideoChannel/Quality')));
    my $authtype = IVRDEServer_getAuthType($vmc{IVRDEServer});

    if ($authtype eq 'External') { $gui{comboboxDispAuthMeth}->set_active(1); }
    elsif ($authtype eq 'Guest') { $gui{comboboxDispAuthMeth}->set_active(2); }
    else { $gui{comboboxDispAuthMeth}->set_active(0); }

    &busy_window($gui{dialogEdit}, 1, undef);
}

sub disp_2D() { IMachine_setAccelerate2DVideoEnabled($vmc{IMachine}, $gui{checkbuttonEditDisp2D}->get_active()); }

sub disp_3D() { IMachine_setAccelerate3DEnabled($vmc{IMachine}, $gui{checkbuttonEditDisp3D}->get_active()); }

sub disp_RDPauth() { IVRDEServer_setAuthType($vmc{IVRDEServer}, &getsel_combo($gui{comboboxDispAuthMeth}, 1)); }

sub disp_RDPmulti() { IVRDEServer_setAllowMultiConnection($vmc{IVRDEServer}, $gui{checkbuttonEditDispMultiple}->get_active()); }

sub disp_vidmem() {
    IMachine_setVRAMSize($vmc{IMachine}, int($gui{adjustmentEditDispVidMem}->get_value()));
    return 0; # Must return this value for the signal used.
}

sub disp_monitors() {
    IMachine_setMonitorCount($vmc{IMachine}, int($gui{adjustmentEditDispMonitor}->get_value()));
    return 0; # Must return this value for the signal used.
}

sub disp_toggleRDP() {
    my $state = $gui{checkbuttonEditDispServer}->get_active();
    IVRDEServer_setEnabled($vmc{IVRDEServer}, $state);
    $gui{tableEditDispRemote}->set_sensitive($state);
}

sub disp_RDPtime() {
    my $authtime = int($gui{entryEditDispAuthTime}->get_text());
    IVRDEServer_setAuthTimeout($vmc{IVRDEServer}, $authtime) if ($authtime);
}

sub disp_RDPport() {
    my $ports = $gui{entryEditDispPort}->get_text();
    IVRDEServer_setVRDEProperty($vmc{IVRDEServer}, 'TCP/Ports', $ports) if ($ports);
}

sub disp_quality() {
    IVRDEServer_setVRDEProperty($vmc{IVRDEServer}, 'VideoChannel/Quality', int($gui{adjustmentEditDispQuality}->get_value()));
    return 0; # Must return this value for the signal used.
}

1;