# Virtualbox Related Enumerators
use strict;
use warnings;

# Medium Variant
our %EMedVar = (Standard             => 0,
                VmdkSplit2G          => 1,
                VmdkStreamOptimizaed => 4,
                VmdkESX              => 8,
                Fixed                => 65536,
                Diff                 => 131072);

# AudioDriverType
our %EAudDrv = (Null        => {desc => 'Dummy Audio Driver',
                                os   => 'All'},
                WinMM       => {desc => 'Windows Multimedia',
                                os   => 'Windows'},
                OSS         => {desc => 'Open Sound System (OSS)',
                                os   => 'Linux'},
                ALSA        => {desc => 'Advanced Linux Sound Architecure (ALSA)',
                                os   => 'Linux'},
                DirectSound => {desc => 'DirectSound',
                                os   => 'Windows'},
                CoreAudio   => {desc => 'CoreAudio',
                                os   => 'Darwin'},
                Pulse       => {desc => 'PulseAudio',
                                os   => 'Linux'},
                SolAudio    => {desc => 'Solaris Audio',
                                os   => 'SunOS'});

# AudioControllerType
our %EAudCtr = (AC97 => 'Intel ICH AC97',
                HDA  => 'Intel High Definition Audio (HDA)',
                SB16 => 'SoundBlaster 16');

# NetworkAdapterType
our %ENetAdap = (Am79C970A => 'AMD PCnet-PCI II',
                 Am79C973  => 'AMD PCnet-FAST III',
                 I82540EM  => 'Intel PRO/1000 MT Desktop',
                 I82543GC  => 'Intel PRO/1000 T Server',
                 I82545EM  => 'Intel PRO/1000 MT Server',
                 Virtio    => 'Paravirtualized Network');

# NetworkAttachmentType
our %ENetAttach = (Null     => 'Not Attached',
                   NAT      => 'NAT',
                   Bridged  => 'Bridged Network',
                   Internal => 'Internal Network',
                   HostOnly => 'Host Only Networking',
                   VDE      => 'VDE (Not Supported Yet)');

# Useful for determining truth (as far as GTK is concerned) based on strings returned
# from the VBox API. Eg for setting a checkbox
our %bool = (Null  => 0,
             null  => 0,
             false => 0,
             False => 0,
             true  => 1,
             True  => 1);

1;