# RemoteBox and VirtualBox preferences
use strict;
use warnings;
our (%gui, %ETruth);
our %prefs = (RDPCLIENT => 'rdesktop -T "%n - RemoteBox" %h:%p');

sub get_prefs() {
    my $prefsdir = Glib::get_user_config_dir();

    if ($prefsdir) {
        if (open(PREFS, "$prefsdir/remotebox.conf")) {
            my @contents = <PREFS>;
            chomp(@contents);
            close(PREFS);
            foreach (@contents) {
                if ($_ =~ m/^URL=(.*)$/) { $prefs{URL}{$1} = 'URL'; }
                elsif ($_ =~ m/^USER=(.*)$/) { $prefs{USER}{$1} = 'USER'; }
                elsif ($_ =~ m/^(.*)=(.*)$/) { $prefs{$1} = $2; }
            }
        }
        else { $prefs{URL}{qq[http://localhost:18083]} = 'URL'; } #Add a default URL
    }
}

sub save_prefs() {
    my $prefsdir = Glib::get_user_config_dir();

    if ($prefsdir) {
        if (open(PREFS, ">$prefsdir/remotebox.conf")) {
            foreach my $key (keys %prefs) {
                if ($key eq 'URL') {
                    foreach (keys %{$prefs{URL}}) { print PREFS "URL=$_\n"; }
                }
                elsif ($key eq 'USER') {
                    foreach (keys %{$prefs{USER}}) { print PREFS "USER=$_\n"; }
                }
                else { print PREFS "$key=$prefs{$key}\n"; }
            }
            close(PREFS);
        }
        else { warn "Unable to save preferences: $prefsdir/remotebox.conf\n"; }
    }
}

sub show_prefs_dialog() {
    $gui{entryPrefsRDPClient}->set_text($prefs{RDPCLIENT});
    my $response = $gui{dialogPrefs}->run;
    $gui{dialogPrefs}->hide;

    if ($response eq 'ok') {
        $prefs{RDPCLIENT} = $gui{entryPrefsRDPClient}->get_text();
        &save_prefs();
    }
}

sub show_vbprefs_dialog() {
    my $ISystemProperties = IVirtualBox_getSystemProperties($gui{websn});
    my %oprefs = (hdfolder  => ISystemProperties_getDefaultHardDiskFolder($ISystemProperties),
                  macfolder => ISystemProperties_getDefaultMachineFolder($ISystemProperties),
                  vrdpauth  => ISystemProperties_getRemoteDisplayAuthLibrary($ISystemProperties));
    $gui{entryVBPrefsGenDefHDFolder}->set_text($oprefs{hdfolder});
    $gui{entryVBPrefsGenDefMachineFolder}->set_text($oprefs{macfolder});
    $gui{entryVBPrefsGenVRDPAuth}->set_text($oprefs{vrdpauth});
    &fill_list_vbprefsnet();
    $gui{dialogVBPrefs}->run();
    $gui{dialogVBPrefs}->hide();
    my %nprefs = (hdfolder  => $gui{entryVBPrefsGenDefHDFolder}->get_text(),
                  macfolder => $gui{entryVBPrefsGenDefMachineFolder}->get_text(),
                  vrdpauth  => $gui{entryVBPrefsGenVRDPAuth}->get_text());
    # For the library, strip any .dll or .so extention
    $nprefs{vrdpauth} =~ s/\.dll$//i;
    $nprefs{vrdpauth} =~ s/\.so$//i;
    ISystemProperties_setDefaultHardDiskFolder($ISystemProperties, $nprefs{hdfolder}) if ($oprefs{hdfolder} ne $nprefs{hdfolder});
    ISystemProperties_setDefaultMachineFolder($ISystemProperties, $nprefs{macfolder}) if ($oprefs{macfolder} ne $nprefs{macfolder});
    ISystemProperties_setRemoteDisplayAuthLibrary($ISystemProperties, $nprefs{vrdpauth}) if ($oprefs{vrdpauth} ne $nprefs{vrdpauth});
}

sub show_hon_dialog() {
    my %if = &getsel_list_vbprefsnet();
    $gui{entryHONAddress}->set_text(IHostNetworkInterface_getIPAddress($if{IHostNetworkInterface}));
    $gui{entryHONNetmask}->set_text(IHostNetworkInterface_getNetworkMask($if{IHostNetworkInterface}));
    $gui{entryHON6Address}->set_text(IHostNetworkInterface_getIPV6Address($if{IHostNetworkInterface}));
    $gui{entryHON6Netmask}->set_text(IHostNetworkInterface_getIPV6NetworkMaskPrefixLength($if{IHostNetworkInterface}));
    # We have to actually prefix the net name with HostInterfaceNetworking- (not mentioned in SDK)
    my $IDHCPServer = IVirtualBox_findDHCPServerByNetworkName($gui{websn}, 'HostInterfaceNetworking-' . $if{Name});
    $gui{checkbuttonHONDHCP}->set_active($ETruth{IDHCPServer_getEnabled($IDHCPServer)});
    $gui{entryHONServerAddress}->set_text(IDHCPServer_getIPAddress($IDHCPServer));
    $gui{entryHONServerMask}->set_text(IDHCPServer_getNetworkMask($IDHCPServer));
    $gui{entryHONLBound}->set_text(IDHCPServer_getLowerIP($IDHCPServer));
    $gui{entryHONUBound}->set_text(IDHCPServer_getUpperIP($IDHCPServer));
    my $response = $gui{dialogHON}->run();
    $gui{dialogHON}->hide();

    if ($response eq 'ok') {
        #Ideally we need some validation here for the IP addresses
        IDHCPServer_setEnabled($IDHCPServer, $gui{checkbuttonHONDHCP}->get_active());
        IDHCPServer_setConfiguration($IDHCPServer,
                                     $gui{entryHONServerAddress}->get_text(),
                                     $gui{entryHONServerMask}->get_text(),
                                     $gui{entryHONLBound}->get_text(),
                                     $gui{entryHONUBound}->get_text());
        IHostNetworkInterface_enableStaticIpConfig($if{IHostNetworkInterface},
                                                   $gui{entryHONAddress}->get_text(),
                                                   $gui{entryHONNetmask}->get_text());
        IHostNetworkInterface_enableStaticIpConfigV6($if{IHostNetworkInterface},
                                                     $gui{entryHON6Address}->get_text(),
                                                     $gui{entryHON6Netmask}->get_text());
        &fill_list_vbprefsnet();
    }
}

sub reset_vbprefs() {
    my ($widget) = @_;
    my $ISystemProperties = IVirtualBox_getSystemProperties($gui{websn});

    if ($widget eq $gui{buttonVBPrefsGenDefHDFolderReset}) {
        ISystemProperties_setDefaultHardDiskFolder($ISystemProperties, '');
        $gui{entryVBPrefsGenDefHDFolder}->set_text(ISystemProperties_getDefaultHardDiskFolder($ISystemProperties));
    }
    elsif ($widget eq $gui{buttonVBPrefsGenDefMachineFolderReset}) {
        ISystemProperties_setDefaultMachineFolder($ISystemProperties, '');
        $gui{entryVBPrefsGenDefMachineFolder}->set_text(ISystemProperties_getDefaultMachineFolder($ISystemProperties));
    }
    elsif ($widget eq $gui{buttonVBPrefsGenDefVRDPAuthReset}) {
        ISystemProperties_setRemoteDisplayAuthLibrary($ISystemProperties, '');
        $gui{entryVBPrefsGenVRDPAuth}->set_text(ISystemProperties_getRemoteDisplayAuthLibrary($ISystemProperties));
    }
}

sub create_hostonly_interface() {
    my $IHost = IVirtualBox_getHost($gui{websn});
    my $IProgress = IHost_createHostOnlyNetworkInterface($IHost);
    &fill_list_vbprefsnet();
}

sub remove_hostonly_interface() {
    my %if = &getsel_list_vbprefsnet();
    my $IHost = IVirtualBox_getHost($gui{websn});
    IHost_removeHostOnlyNetworkInterface($IHost, $if{Uuid});
    &fill_list_vbprefsnet();
}

1;