# Virtualbox Related Enumerators
use strict;
use warnings;

our %EAudioDriverType = (Null        => {desc => 'Dummy Audio Driver',
                                         os   => 'All'},
                         WinMM       => {desc => 'Windows Multimedia',
                                         os   => 'Windows'},
                         OSS         => {desc => 'Open Sound System (OSS)',
                                         os   => 'Linux'},
                         ALSA        => {desc => 'Advanced Linux Sound Architecure (ALSA)',
                                         os   => 'Linux'},
                         DirectSound => {desc => 'DirectSound',
                                         os   => 'Windows'},
                         CoreAudio   => {desc => 'CoreAudio',
                                         os   => 'Darwin'},
                         Pulse       => {desc => 'PulseAudio',
                                         os   => 'Linux'},
                         SolAudio    => {desc => 'Solaris Audio',
                                         os   => 'SunOS'});

our %EAudioControllerType = (AC97 => 'Intel ICH AC97',
                             SB16 => 'SoundBlaster 16');

our %ENetworkAdapterType = (Am79C970A => 'AMD PCnet-PCI II',
                            Am79C973  => 'AMD PCnet-FAST III',
                            I82540EM  => 'Intel PRO/1000 MT Desktop',
                            I82543GC  => 'Intel PRO/1000 T Server',
                            I82545EM  => 'Intel PRO/1000 MT Server',
                            Virtio    => 'Paravirtualized Network');

our %ENetworkAttachmentType = (Null     => 'Not Attached',
                               NAT      => 'Network Address Translation (NAT)',
                               Bridged  => 'Bridged Network',
                               Internal => 'Internal Network',
                               HostOnly => 'Host Only Networking',
                               VDE      => 'VDE (Not Supported Yet)');

# Useful for determining truth (as far as GTK is concerned) based on strings returned
# from the VBox API. Eg for setting a checkbox
our %ETruth = (Null  => 0,
               null  => 0,
               false => 0,
               False => 0,
               true  => 1,
               True  => 1);

# Useful for transforming truth strings for the VBOX API into Enabled/Disabled strings
our %EAbled = (Null  => 'Disabled',
               null  => 'Disabled',
               false => 'Disabled',
               False => 'Disabled',
               true  => 'Enabled',
               True  => 'Enabled');

1;